// ValidateSN.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include <tchar.h>
#include <stdlib.h>
#include "ValidateSN.h"

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    return TRUE;
}

LONG WINAPI ValidateSN(HWND hwnd, LPSTR szSrcDir, LPSTR szSupport, LPSTR szSerialNum, LPSTR szDbase)
{
	//Check for proper length
	if (_tcslen( szSerialNum ) != SERIALNUMBER_LENGTH)
	{
		#ifdef _DEBUG //Display Debug information
			MessageBox(GetFocus(), szSerialNum, "Length Validation Failed", MB_OK);		
		#endif
		return VALDIATION_FAILED;
	}

	//Copy serial number to temp variable before parsing
	TCHAR szTemp[255];
	_tcscpy(szTemp, szSerialNum);


	//Get individual fields of the serial number (tokens separated by '-' chracter)
	LPSTR szField1 = _tcstok( szTemp, TOKEN_SEPERATOR );
    LPSTR szField2 = _tcstok( NULL, TOKEN_SEPERATOR );
    LPSTR szField3 = _tcstok( NULL, TOKEN_SEPERATOR );

	#ifdef _DEBUG  //Display Debug information
		CHAR szTmp[1024];
		wsprintf(szTmp, "szSerialNum=%s. \nField #1=%s \nField #2=%s \nField #3=%s", szSerialNum, szField1, szField2, szField3);
		MessageBox(GetFocus(), szTmp, "Serial Number Debug Window", MB_OK);
	#endif

	//Validate three fields in this example
	if (ValidateField1(szField1) != VALIDATION_SUCCESS)
	{
		#ifdef _DEBUG //Display Debug information
			MessageBox(GetFocus(), szField1, "Field #1 Validation Failed", MB_OK);		
		#endif

		return VALDIATION_FAILED;
	}
	else if (ValidateField2(szField2) != VALIDATION_SUCCESS)
	{
		#ifdef _DEBUG //Display Debug information
			MessageBox(GetFocus(), szField2, "Field #2 Validation Failed", MB_OK);
		#endif

	    return VALDIATION_FAILED;
	}
	else if (ValidateField3(szField3) != VALIDATION_SUCCESS)
	{
		#ifdef _DEBUG //Display Debug information
			MessageBox(GetFocus(), szField3, "Field #3 Validation Failed", MB_OK);
		#endif

		return VALDIATION_FAILED;
	}
	else
		return VALIDATION_SUCCESS;
}

LONG ValidateField1(LPSTR szField1)
{
	//First field must be the string 'Field1'
	return _tcsicmp (szField1, SERIALNUM_FIELD1);
}

LONG ValidateField2(LPSTR szField2)
{

	long lNumToValidate = atoi (szField2);

	//Second field must be a multiple of 5
	if ((lNumToValidate % 5) == 0)
		return VALIDATION_SUCCESS;
	else 
		return VALDIATION_FAILED;
}

LONG ValidateField3(LPSTR szField3)
{
	//Don't do anything - accept all values in third field
	return VALIDATION_SUCCESS;

}